% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protectTable.R
\name{protectTable}
\alias{protectTable}
\title{Protecting \linkS4class{sdcProblem} objects}
\usage{
protectTable(object, method, ...)
}
\arguments{
\item{object}{a \linkS4class{sdcProblem} object that has created using \code{\link[=makeProblem]{makeProblem()}} and has
been modified by \code{\link[=primarySuppression]{primarySuppression()}}}

\item{method}{a character vector of length 1 specifying the algorithm that should be
used to protect the primary sensitive table cells. Allowed values are:
\itemize{
\item \code{"OPT"}: protect the complete problem at once using a cut and branch algorithm. The optimal
algorithm should be used for small problem-instances only.
\item \code{"HITAS"}: split the overall problem in smaller problems. These problems are
protected using a top-down approach.
\item \code{"HYPERCUBE"}: protect the complete problem by protecting sub-tables with a fast
heuristic that is based on finding and suppressing geometric structures (n-dimensional cubes)
that are required to protect primary sensitive table cells.
\item \code{"SIMPLEHEURISTIC"} and \code{"SIMPLEHEURISTIC_OLD"}: heuristic procedures which might be applied to
large(r) problem instances;
\itemize{
\item \code{"SIMPLEHEURISTIC"} is based on constraints; it also solves attacker problems to make sure
each primary sensitive cell cannot be recomputed;
\item \code{"SIMPLEHEURISTIC_OLD"} was the implementation in \code{sdcTable} versions prior to \code{0.32}; this
implementation is possibly unsafe but very fast; it is advised to check results using \code{\link[=attack]{attack()}}
afterwards.
}
}}

\item{...}{parameters used in the protection algorithm that has been selected. Parameters that
can be changed are:
\itemize{
\item \strong{general parameters}:
\itemize{
\item \code{verbose}: logical scalar (default is \code{FALSE}) defining if verbose output should be produced
\item \code{save}: logical scalar defining if temporary results should be saved in the current
working directory (\code{TRUE}) or not (\code{FALSE}) which is the default value.
}
\item parameters used for \strong{"HITAS"} and \strong{"OPT"} algorithms:
\itemize{
\item \code{solver}: character vector of length 1 defining the solver to be used. Currently available choices
are limited to \code{"glpk"}.
\item \code{timeLimit}: numeric vector of length 1 (or NULL) defining a time limit in minutes after which the
cut and branch algorithm should stop and return a possible non-optimal solution. Parameter \code{safe} has
a default value of \code{NULL}
\item \code{maxVars}: a integerish number (or \code{NULL}) defining the maximum problem size in terms of
decision variables for which an optimization should be tried. If the number of decision variables
in the current problem are larger than parameter \code{maxVars}, only a possible non-optimal, heuristic solution
is calculated. Parameter \code{maxVars} has a default value of \code{NULL} (no restrictions)
\item \code{fastSolution}: logical scalar defining (default \code{FALSE}) if or if not the cut and branch algorithm will be started or if
the possibly non-optimal heuristic solution is returned independent of parameter \code{maxVars}.
\item \code{fixVariables}: logical scalar (default \code{TRUE}) defining whether or not it should be tried to fix some variables
to \code{0} or \code{1} based on reduced costs early in the cut and branch algorithm.
\item \code{approxPerc}: integerish scalar that defines a percentage for which a integer solution of the cut and branch
algorithm is accepted as optimal with respect to the upper bound given by the (relaxed) solution of the
master problem. Its default value is set to \code{10}
\item \code{useC}: logical scalar defining if c++ implementation of the secondary cell
suppression problem should be used, defaults to \code{FALSE}
}
\item parameters used for \strong{"HYPERCUBE"} procedure:
\itemize{
\item \code{protectionLevel}: numeric vector of length 1 specifying the required protectionlevel for the procedure. Its default value is \code{80}
\item \code{suppMethod}: character vector of length 1 defining the rule on how to select the
'optimal' cube to protect a single sensitive cells. Possible choices are:
\itemize{
\item \code{minSupps}: minimize the number of additional secondary suppressions (this is also the default setting).
\item \code{minSum}: minimize the sum of counts of additional suppressed cells
\item \code{minSumLogs}: minimize the log of the sum of additional suppressed cells
}
\item \code{suppAdditionalQuader}: logical vector of length 1 specfifying if additional cubes should be
suppressed if any secondary suppressions in the 'optimal' cube are 'singletons'. Parameter
\code{suppAdditionalQuader} has a default value of \code{FALSE}
}
\item parameter(s) used for \code{\link[=protect_linked_tables]{protect_linked_tables()}}:
\itemize{
\item \code{maxIter}: integerish number specifying the maximal number of interations that should be make
while trying to protect common cells of two different tables. The default value of parameter is \code{10}
}
\item parameters used for the \strong{"SIMPLEHEURISTIC"} and \strong{"SIMPLEHEURISTIC_OLD"} procedure:
\itemize{
\item \code{detectSingletons}: logical, should a singleton-detection procedure be run before protecting the
data, defaults to \code{FALSE}.
\item \code{threshold}: if not \code{NULL} (the default) an integerish number (> \code{0}). If specified, a procedure similar
to the singleton-detection procedure is run that makes sure that for all (simple) rows in the table instance that
contains primary sensitive cells the suppressed number of contributors is \code{>=} the specified threshold.
}
\item parameters used for the \strong{"GAUSS"} procedure; for details please see \code{?SSBtools::GaussSuppression} as
the default values are the same as in this function:
\itemize{
\item \code{removeDuplicated}: should duplicated columns be removed before running the protection algorithm
\item \code{whenEmptySuppressed}: a function to be called when primary suppressed input is problematic; \code{NULL}
(default) does not apply any function
\item \code{whenEmptyUnsuppressed}: a function to be called when empty candidate cells aredevto problematic; \code{NULL}
(default) does not apply any function
\item \code{singletonMethod}: parameter \code{singletonMethod} in \code{\link[SSBtools:GaussSuppression]{SSBtools::GaussSuppression()}}; default \code{"anySum"}
}
}}
}
\value{
an \linkS4class{safeObj} object
}
\description{
Function \code{\link[=protectTable]{protectTable()}} is used to protect primary sensitive table cells
(that usually have been identified and set using
\code{\link[=primarySuppression]{primarySuppression()}}). The function protects primary
sensitive table cells according to the method that has been chosen and the
parameters that have been set. Additional parameters that are used to control
the protection algorithm are set using parameter \code{...}.
}
\details{
The implemented methods may have bugs that yield in not-fully protected tables. Especially
the usage of \code{"OPT"}, \code{"HITAS"} and \code{"HYPERCUBE"} in production is not
suggested as these methods may eventually be removed completely. In case you encounter any problems,
please report it or use Tau-Argus (\url{https://research.cbs.nl/casc/tau.htm}).
}
\examples{
# load example-problem with with a single primary suppression
# (same as example from ?primarySuppression)
p <- sdc_testproblem(with_supps = TRUE)

# protect the table using the 'GAUSS' algorithm with verbose output
res1 <- protectTable(p, method = "GAUSS", verbose = TRUE)
res1

# protect the table using the 'HITAS' algorithm with verbose output
res2 <- protectTable(p, method = "HITAS", verbose = TRUE, useC = TRUE)
res2

# protect using the heuristic algorithm
res3 <- protectTable(p, method = "SIMPLEHEURISTIC")
res3

# protect using the old implmentation of the heuristic algorithm
# used in sdcTable versions <0.32
res4 <- protectTable(p, method = "SIMPLEHEURISTIC_OLD")
res4

# looking at the final table with result suppression pattern
print(getInfo(res1, type = "finalData"))
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
