% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{plotSurface3D}
\alias{plotSurface3D}
\title{Visualization of a 3D surface}
\usage{
plotSurface3D(x = 1:nrow(t), y = 1:ncol(t), z = 1:dim(t)[3], f,
  t = NULL, nLev = 20, levels = NULL, fVect = FALSE, size = 15,
  alpha = 0.05, ...)
}
\arguments{
\item{x, y, z}{numerical grids for each dimension.}

\item{f}{function to be plot. Must take a single argument (see examples).}

\item{t}{a vector of length \code{length(x) * length(y) * length(z)} containing the evaluation of \code{f} in the trivariate grid. If not provided, it is computed internally.}

\item{nLev}{number of levels in the colour scale.}

\item{levels}{vector of breaks in the colour scale. If not provided, it is set to \code{quantile(z, probs = seq(0, 1, l = nLev))}.}

\item{fVect}{flag to indicate whether \code{f} is a vectorized function (see examples).}

\item{size}{size of points in pixels.}

\item{alpha}{alpha value between \code{0} (fully transparent) and \code{1} (opaque).}

\item{...}{further arguments passed to \code{\link[rgl]{plot3d}}}
}
\value{
The vector \code{t}, invisible.
}
\description{
Convenient wrapper for visualizing a real function of three variables by means of a colour scale and alpha shading.
}
\examples{
\donttest{
grid <- seq(-pi, pi, l = 50)
t <- plotSurface3D(grid, grid, grid, size = 10, alpha = 0.01, fVect = TRUE,
                   f = function(x) 10 * (sin(x[, 1]) * cos(x[, 2]) - sin(x[, 3]))^2)
plotSurface3D(grid, grid, grid, t = t, size = 15, alpha = 0.1,
              levels = quantile(t, probs = seq(0, 0.1, l = 20)))
}
}
\keyword{internal}
