% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dStatWn2D}
\alias{dStatWn2D}
\title{Stationary density of a WN diffusion (with diagonal diffusion matrix) in 2D}
\usage{
dStatWn2D(x, alpha, mu, sigma, rho = 0, maxK = 2L, expTrc = 30)
}
\arguments{
\item{x}{a matrix of dimension \code{c(n, 2)} containing angles. They all must be in \eqn{[\pi,\pi)} so that the truncated wrapping by \code{maxK} windings is able to capture periodicity.}

\item{alpha}{vector of length \code{3} parametrizing the \code{A} matrix as in \code{\link{alphaToA}}.}

\item{mu}{a vector of length \code{2} giving the mean.}

\item{sigma}{vector of length \code{2} containing the \strong{square root} of the diagonal of \eqn{\Sigma}, the diffusion matrix.}

\item{rho}{correlation coefficient of \eqn{\Sigma}.}

\item{maxK}{maximum absolute value of the windings considered in the computation of the WN.}

\item{expTrc}{truncation for exponential: \code{exp(x)} with \code{x <= -expTrc} is set to zero. Defaults to \code{30}.}
}
\value{
A vector of size \code{n} containing the stationary density evaluated at \code{x}.
}
\description{
Stationary density of the WN diffusion.
}
\examples{
set.seed(345567)
alpha <- c(2, 1, -1)
sigma <- c(1.5, 2)
Sigma <- diag(sigma^2)
A <- alphaToA(alpha = alpha, sigma = sigma)
mu <- c(pi, pi)
dStatWn2D(x = toPiInt(matrix(1:20, nrow = 10, ncol = 2)), mu = mu,
          alpha = alpha, sigma = sigma)
dTpdWou(t = 10, x = toPiInt(matrix(1:20, nrow = 10, ncol = 2)), A = A,
         mu = mu, Sigma = Sigma, x0 = mu)
xth <- seq(-pi, pi, l = 100)
contour(xth, xth, matrix(dStatWn2D(x = as.matrix(expand.grid(xth, xth)),
                                   alpha = alpha, sigma = sigma, mu = mu),
                         nrow = length(xth), ncol = length(xth)), nlevels = 50)
points(rStatWn2D(n = 1000, mu = mu, alpha = alpha, sigma = sigma), col = 2)
}
