% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etp.R
\name{etp}
\alias{etp}
\title{Educational Testing Problem}
\usage{
etp(B)
}
\arguments{
\item{B}{A symmetric positive definite matrix}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant c matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{etp} creates input for sqlp to solve the Educational Testing Problem -
given a symmetric positive definite matrix S, how much can be subtracted from the diagonal
elements of S such that the resulting matrix is positive semidefinite definite.
}
\details{
Solves the education testing problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
data(Betp)

out <- etp(Betp)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

}

