% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lovasz.R
\name{lovasz}
\alias{lovasz}
\title{Lovasz Number of a Graph}
\usage{
lovasz(G)
}
\arguments{
\item{G}{An adjacency matrix corresponding to a graph}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant c matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{lovasz} creates input for sqlp to find the Lovasz Number of a graph
}
\details{
Finds the maximum Shannon entropy of a graph, more commonly known as the Lovasz number. 
Mathematical and implementation details can be found in the vignette
}
\examples{
data(Glovasz)

out <- lovasz(Glovasz)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

}

