% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratification.R
\name{hclustgeo_disc}
\alias{hclustgeo_disc}
\title{hierarchical clustering with spatial soft constraints}
\usage{
hclustgeo_disc(data, n, alpha = 0.5, D1 = NULL, scale = TRUE, wt = NULL, ...)
}
\arguments{
\item{data}{An \code{sf} object, \code{tibble}, \code{data.frame}, \code{matrix} or \code{vector} of observations data.}

\item{n}{The number of hierarchical clustering classes, which can be a numeric value or vector.}

\item{alpha}{(optional) A positive value between \code{0} and \code{1}. This mixing parameter gives the
relative importance of "feature" space and "constraint" space. Default is \code{0.5}.}

\item{D1}{(optional) A \code{matrix} with other dissimilarities between the same observations data. if \code{data}
is an \code{sf} object and alpha is not \code{0}, the \code{D1} will be generated by \code{sdsfun::sf_distance_matrix()},
others will use a \code{matrix} with all elements equal to \code{0}.}

\item{scale}{(optional) Whether to scaled the dissimilarities matrix, default is \code{TRUE}.}

\item{wt}{(optional) Vector with the weights of the observations. By default, \code{wt} is \code{NULL}.}

\item{...}{(optional) Other arguments passed to \code{stats::dist()}.}
}
\value{
A \code{vector} with grouped memberships if \code{n} are \code{scalar}, otherwise a \code{matrix} with grouped
memberships is returned where each column corresponds to the elements of \code{n}, respectively.
}
\description{
hierarchical clustering with spatial soft constraints
}
\note{
This is a \verb{C++} enhanced implementation of the \code{hclustgeo} function in \code{ClustGeo} package.
}
\examples{
gzma = sf::read_sf(system.file('extdata/gzma.gpkg',package = 'sdsfun'))
gzma$group = hclustgeo_disc(gzma,5,alpha = 0.75)
plot(gzma["group"])

}
