% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.R
\name{assign_no_ct}
\alias{assign_no_ct}
\alias{assign_ct}
\alias{assign}
\title{Derive an SDTM variable}
\usage{
assign_no_ct(
  tgt_dat = NULL,
  tgt_var,
  raw_dat,
  raw_var,
  id_vars = oak_id_vars()
)

assign_ct(
  tgt_dat = NULL,
  tgt_var,
  raw_dat,
  raw_var,
  ct_spec,
  ct_clst,
  id_vars = oak_id_vars()
)
}
\arguments{
\item{tgt_dat}{Target dataset: a data frame to be merged against \code{raw_dat} by
the variables indicated in \code{id_vars}. This parameter is optional, see
section Value for how the output changes depending on this argument value.}

\item{tgt_var}{The target SDTM variable: a single string indicating the name
of variable to be derived.}

\item{raw_dat}{The raw dataset (dataframe); must include the
variables passed in \code{id_vars} and \code{raw_var}.}

\item{raw_var}{The raw variable: a single string indicating the name of the
raw variable in \code{raw_dat}.}

\item{id_vars}{Key variables to be used in the join between the raw dataset
(\code{raw_dat}) and the target data set (\code{raw_dat}).}

\item{ct_spec}{Study controlled terminology specification: a dataframe with a
minimal set of columns, see \code{\link[=ct_spec_vars]{ct_spec_vars()}} for details.}

\item{ct_clst}{A codelist code indicating which subset of the controlled
terminology to apply in the derivation.}
}
\value{
The returned data set depends on the value of \code{tgt_dat}:
\itemize{
\item If no target dataset is supplied, meaning that \code{tgt_dat} defaults to
\code{NULL}, then the returned data set is \code{raw_dat}, selected for the variables
indicated in \code{id_vars}, and a new extra column: the derived variable, as
indicated in \code{tgt_var}.
\item If the target dataset is provided, then it is merged with the raw data set
\code{raw_dat} by the variables indicated in \code{id_vars}, with a new column: the
derived variable, as indicated in \code{tgt_var}.
}
}
\description{
\itemize{
\item \code{\link[=assign_no_ct]{assign_no_ct()}} maps a variable in a raw dataset to a target SDTM
variable that has no terminology restrictions.
\item \code{\link[=assign_ct]{assign_ct()}} maps a variable in a raw dataset to a target SDTM variable
following controlled terminology recoding.
}
}
\examples{

md1 <-
  tibble::tibble(
    oak_id = 1:14,
    raw_source = "MD1",
    patient_number = 101:114,
    MDIND = c(
      "NAUSEA", "NAUSEA", "ANEMIA", "NAUSEA", "PYREXIA",
      "VOMITINGS", "DIARHHEA", "COLD",
      "FEVER", "LEG PAIN", "FEVER", "COLD", "COLD", "PAIN"
    )
  )

assign_no_ct(
  tgt_var = "CMINDC",
  raw_dat = md1,
  raw_var = "MDIND"
)

cm_inter <-
  tibble::tibble(
    oak_id = 1:14,
    raw_source = "MD1",
    patient_number = 101:114,
    CMTRT = c(
      "BABY ASPIRIN",
      "CORTISPORIN",
      "ASPIRIN",
      "DIPHENHYDRAMINE HCL",
      "PARCETEMOL",
      "VOMIKIND",
      "ZENFLOX OZ",
      "AMITRYPTYLINE",
      "BENADRYL",
      "DIPHENHYDRAMINE HYDROCHLORIDE",
      "TETRACYCLINE",
      "BENADRYL",
      "SOMINEX",
      "ZQUILL"
    ),
    CMROUTE = c(
      "ORAL",
      "ORAL",
      NA,
      "ORAL",
      "ORAL",
      "ORAL",
      "INTRAMUSCULAR",
      "INTRA-ARTERIAL",
      NA,
      "NON-STANDARD",
      "RANDOM_VALUE",
      "INTRA-ARTICULAR",
      "TRANSDERMAL",
      "OPHTHALMIC"
    )
  )

# Controlled terminology specification
(ct_spec <- read_ct_spec_example("ct-01-cm"))

assign_ct(
  tgt_dat = cm_inter,
  tgt_var = "CMINDC",
  raw_dat = md1,
  raw_var = "MDIND",
  ct_spec = ct_spec,
  ct_clst = "C66729"
)

}
