% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd_df.R
\name{eval_conditions}
\alias{eval_conditions}
\title{Evaluate conditions}
\usage{
eval_conditions(dat, ..., .na = NA, .env = rlang::caller_env())
}
\arguments{
\item{dat}{A data frame}

\item{...}{A set of logical conditions, e.g. \verb{y & z, x | z} (\code{x}, \code{y}, \code{z}
would have to exist either as columns in \code{dat} or in the environment
\code{.env}). If multiple expressions are included, they are combined with the
\code{&} operator.}

\item{.na}{Return value to be used when the conditions evaluate to \code{NA}.}

\item{.env}{An optional environment to look for variables involved in logical
expression passed in \code{...}. A data frame or a list can also be passed that
will be coerced to an environment internally.}
}
\value{
A logical vector reflecting matching rows in \code{dat}.
}
\description{
\code{\link[=eval_conditions]{eval_conditions()}} evaluates a set of conditions in the context of a
data frame and an optional environment.

The utility of this function is to provide an easy way to generate a logical
vector of matching records from a set of logical conditions involving
variables in a data frame (\code{dat}) and optionally in a supplementary
environment (\code{.env}). The set of logical conditions are provided as
expressions to be evaluated in the context of \code{dat} and \code{.env}.

Variables are looked up in \code{dat}, then in \code{.env}, then in the calling
function's environment, followed by its parent environments.
}
\keyword{internal}
