% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search-functions.R
\name{searcher}
\alias{searcher}
\title{Generate a Searcher function for use with Error Handling}
\usage{
searcher(site = c("google", "bing", "ddg", "so", "gh", "bb", "duckduckgo",
  "stackoverflow", "github", "bitbucket", "ixquick"), rlang = TRUE)
}
\arguments{
\item{site}{Name of site to search on. Supported options:
\code{"google"} (default), \code{"stackoverflow"}, \code{"github"}, \code{"bing"},
\code{"bitbucket"}}

\item{rlang}{Search for results written in R. Default is \code{TRUE}}
}
\description{
Constructs a function object that will search the last
R error message on search portals by opening a
browser.
}
\details{
This function acts as a closure. Thus, you will receive
a function back when only specifying the \code{site} parameter.
To call the function, add a second set of parentheses.
}
\section{Generic Error Search}{

The \code{searcher} function grabs the last error message and
tries to search it. This function will ensure that R language
is the primary search context.
}

\examples{
### Manually
searcher("google")()

\dontrun{
### Automatically
# On error, automatically search the message on google
options(error = searcher("google"))
}
}
