% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_participants}
\alias{get_participants}
\title{Retrieves participants present in \code{secuTrialdata}}
\usage{
get_participants(dat)
}
\arguments{
\item{dat}{\code{secuTrialdata} object containing participant IDs and centre information}
}
\value{
data.frame containing participants present in dat
}
\description{
Given a \code{secuTrialdata} object, this function simply returns a list of participants.
Information included are participant IDs and corresponding study centre information,
if available.
}
\examples{

path <- system.file("extdata", "sT_exports", "exp_opt",
                    "s_export_CSV-xls_CTU05_all_info.zip",
                    package = "secuTrialR")
sT_export <- read_secuTrial(path)

# show participants
participants <- get_participants(sT_export)

}
