% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_pizza.R
\name{scale_color_pizza}
\alias{scale_color_pizza}
\alias{scale_color_pizza_d}
\alias{scale_color_pizza_c}
\alias{scale_colour_pizza}
\alias{scale_colour_pizza_c}
\alias{scale_colour_pizza_d}
\alias{scale_fill_pizza}
\alias{scale_fill_pizza_d}
\alias{scale_fill_pizza_c}
\title{Pizza color palette}
\usage{
scale_color_pizza(palette = "margherita", discrete = TRUE,
  reverse = FALSE, ...)

scale_color_pizza_d(palette = "margherita", discrete = TRUE,
  reverse = FALSE, ...)

scale_color_pizza_c(palette = "margherita", discrete = FALSE,
  reverse = FALSE, ...)

scale_colour_pizza(palette = "margherita", discrete = TRUE,
  reverse = FALSE, ...)

scale_colour_pizza_c(palette = "margherita", discrete = FALSE,
  reverse = FALSE, ...)

scale_colour_pizza_d(palette = "margherita", discrete = TRUE,
  reverse = FALSE, ...)

scale_fill_pizza(palette = "margherita", discrete = TRUE,
  reverse = FALSE, ...)

scale_fill_pizza_d(palette = "margherita", discrete = TRUE,
  reverse = FALSE, ...)

scale_fill_pizza_c(palette = "margherita", discrete = FALSE,
  reverse = FALSE, ...)
}
\arguments{
\item{palette}{Pizza type. Can be "margherita" (default), "margherita_crust",
"diavola" or "diavola_crust".}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{...}{Additional arguments to pass to \code{\link[=colorRampPalette]{colorRampPalette()}}.}
}
\description{
The palette based on authentic neapolitan pizzas.
Use \code{scale_color_pizza_d()} for \emph{discrete} categories and
\code{scale_color_pizza_c()} for a \emph{continuous} scale.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_boxplot() +
  theme_modern() +
  scale_fill_pizza_d()

ggplot(iris, aes(x = Petal.Length, y = Petal.Width, color = Sepal.Length)) +
  geom_point() +
  theme_modern() +
  scale_color_pizza_c()

}
