% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.estimate_density.R
\name{plot.see_estimate_density}
\alias{plot.see_estimate_density}
\title{Plot method for density estimation of posterior samples}
\usage{
\method{plot}{see_estimate_density}(
  x,
  stack = TRUE,
  show_intercept = FALSE,
  n_columns = 1,
  priors = FALSE,
  priors_alpha = 0.4,
  size = 0.9,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{stack}{Logical, if \code{TRUE}, densities are plotted as stacked lines.
Else, densities are plotted for each parameter among each other.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the intercept-parameter
has a posterior distribution on a very different location, so density curves of
posterior distributions for other parameters are hardly visible.}

\item{n_columns}{For models with multiple components (like fixed and random, count and zero-inflated), defines the number of columns for the panel-layout. If \code{NULL}, a single, integrated plot is shown.}

\item{priors}{Logical, if \code{TRUE}, prior distributions are simulated
(using \code{\link[bayestestR]{simulate_prior}}) and added to the plot.}

\item{priors_alpha}{Alpha value of the prior distributions.}

\item{size}{Size of geoms. Depends on the context of the \code{plot()} function,
so this argument may change size of points, lines or bars.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{bayestestR::estimate_density()} function.
}
\examples{
\donttest{
if (require("bayestestR") && require("rstanarm")) {
  set.seed(123)
  m <<- stan_glm(Sepal.Length ~ Petal.Width * Species, data = iris, refresh = 0)
  result <- estimate_density(m)
  plot(result)
}
}
}
