% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecewise_model.R
\name{piecewise_model}
\alias{piecewise_model}
\title{Analysis: Piecewise regression}
\usage{
piecewise_model(
  trat,
  resp,
  middle = 1,
  CI = FALSE,
  bootstrap.samples = 1000,
  sig.level = 0.05,
  error = "SE",
  ylab = "Germination (\%)",
  xlab = expression("Temperature ("^"o" * "C)"),
  theme = theme_classic(),
  cardinal = 0,
  legend.position = "top"
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{middle}{A scalar in [0,1]. This represents the range that the change-point can occur in. 0 means the change-point must occur at the middle of the range of x-values. 1 means that the change-point can occur anywhere along the range of the x-values.}

\item{CI}{Whether or not a bootstrap confidence interval should be calculated. Defaults to FALSE because the interval takes a non-trivial amount of time to calculate}

\item{bootstrap.samples}{The number of bootstrap samples to take when calculating the CI.}

\item{sig.level}{What significance level to use for the confidence intervals.}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{cardinal}{defines the value of y considered extreme (\emph{default} considers 0 germination)}

\item{legend.position}{legend position (\emph{default} is c(0.3,0.8))}
}
\value{
The function returns the coefficients and respective p-values; statistical parameters such as AIC, BIC, pseudo-R2; cardinal and optimal temperatures and the graph using ggplot2 with the equation.
}
\description{
Fit a degree 1 spline with 1 knot point where the location of the knot point is unknown.
}
\note{
if the maximum predicted value is equal to the maximum x, the curve does not have a maximum point within the studied range. If the minimum value is less than the lowest point studied, disregard the value.
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)
piecewise_model(trat,resp)
}
\references{
Chiu, G. S., R. Lockhart, and R. Routledge. 2006. Bent-cable regression theory and applications. Journal of the American Statistical Association 101:542-553.

Toms, J. D., and M. L. Lesperance. 2003. Piecewise regression: a tool for identifying ecological thresholds. Ecology 84:2034-2041.
}
\author{
Model imported from the SiZer package

Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
