% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quali_model.R
\name{quali_model}
\alias{quali_model}
\title{Analysis: generalized linear models for factor qualitative}
\usage{
quali_model(
  trat,
  resp,
  method = "glm",
  n = 50,
  family = "binomial",
  ylab = "Germination (\%)",
  xlab = expression("Temperature ("^"o" * "C)"),
  reversed = TRUE,
  angle = 0,
  sup = NA,
  theme = theme_classic()
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{resp}{Numerical vector containing the response in percentage of the experiment.}

\item{method}{method for analysis (analysis of variance - aov or analysis by generalized linear model - glm)}

\item{n}{Number of seeds per repetition}

\item{family}{a description of the error distribution and link function to be used in the model. For glm this can be a character string naming a family function, a family function or the result of a call to a family function.}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{reversed}{Letter order (\emph{default} is FALSE)}

\item{angle}{x-axis scale text rotation}

\item{sup}{Number of units above the standard deviation or average bar on the graph}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}
}
\value{
The function returns analysis by glm (binomial or quasibinomial family), post-hoc and column graph
}
\description{
Performs the deviance analysis for the generalized linear model using binomial or quasibinomial family. The function also returns multiple comparison test with tukey adjustment
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)
quali_model(trat, germ, n=25, family="quasibinomial")
}
