% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createC.R
\name{createCompModel}
\alias{createCompModel}
\title{Create compilable c-code of a model}
\usage{
createCompModel(modelFunc, parameters, bden, nnStates)
}
\arguments{
\item{modelFunc}{a R-function that can be solved with deSolve. External input of the system should
be declared with 'u'. To ensure that the function is working use the most general
state-space representation.}

\item{parameters}{a vector describing the parameters of the system. If names are missing the function
tries to extract the declared parameters from the model function.}

\item{bden}{a boolean that indicates if the c-file is used for the mcmc algorithm, default value is 'FALSE'}

\item{nnStates}{a bit vector indicating the states that should be non negative}
}
\value{
None
}
\description{
Writes a c file that can be compiled for faster solution with the \code{\link[deSolve]{ode}} solver.
The file created is formatted to be used with the dynamic elastic net. A hidden input is 
added to every component of the state vector.
}
\note{
On the usage of compiled code in conjunction with \pkg{deSolve} take a look into the vignette 'R
Package deSolve, Writing Code in Compiled Languages' of the package.
}
