% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seeds.R
\docType{package}
\name{seeds-package}
\alias{seeds}
\alias{seeds-package}
\title{seeds: Estimate Hidden Inputs using the Dynamic Elastic Net}
\description{
Algorithms to calculate the hidden inputs of systems of differential equations. 
  These hidden inputs can be interpreted as a control that tries to minimize the
  discrepancies between a given model and taken measurements. The idea is 
  also called the Dynamic Elastic Net, as proposed in the paper "Learning (from) the errors of a systems biology model" 
  (Engelhardt, Froelich, Kschischo 2016) <doi:10.1038/srep20772>.
  To use the experimental SBML import function, the RSBML package is required. For installation I refer to the official rsbml page: https://bioconductor.org/packages/release/bioc/html/rsbml.html.
}
\details{
Details

The first algorithm (SGDN) calculates the needed equations using the \code{\link{Deriv}}
function of the \pkg{Deriv} package. The process is implemented through the use
of the S4 class \code{\link{odeEquations-class}}. 

The conjugate gradient based algorithm uses a greedy algorithm to estimate a 
sparse control that tries to minimize the discrepancies between a given 
'nominal model given the measurements (e.g from an experiment). The algorithm
the \code{\link{ode}} uses \pkg{deSolve} to calculate the hidden inputs w 
based on the adjoint equations of the ODE-System. 

The adjoint equations are calculated using the \code{\link{ode}} function of the 
\pkg{deSolve} package. For the usage of the algorithm please look into the 
examples and documentation given for the functions.

The second algorithm is called Bayesian Dynamic Elastic Net (BDEN).
The BDEN as a new and fully probabilistic approach, supports the modeller in an 
algorithmic manner to identify possible sources of errors in ODE based models on 
the basis of experimental data.  THE BDEN does not require pre-specified hyper-parameters. 
BDEN thus provides a systematic Bayesian computational method to identify target nodes and 
reconstruct the corresponding error signal including detection of missing and 
wrong molecular interactions within the assumed model. The method works for ODE 
based systems even with uncertain knowledge and noisy data. 

\describe{
   \item{\code{\link[seeds]{sgdn}}}{a greedy algorithm to calculate a sparse control}
   \item{\code{\link[seeds]{BDEN}}}{a basian mcmc approach}
}
}
\references{
\strong{Benjamin Engelhardt, Holger Froehlich, Maik Kschischo} 
Learning (from) the errors of a systems biology model, \emph{Nature Scientific Reports},
 6, 20772, 2016 \url{https://www.nature.com/articles/srep20772}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Newmi1988/seeds}
  \item Report bugs at \url{https://github.com/Newmi1988/seeds/issues}
}

}
\author{
\strong{Maintainer}: Tobias Newmiwaka \email{tobias.newmiwaka@gmail.com}

Authors:
\itemize{
  \item Benjamin Engelhardt \email{engelhar@bit.uni-bonn.de}
}

}
