% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelClass.R
\name{setParms}
\alias{setParms}
\alias{setParms,odeModel,numeric-method}
\title{Set the model parameters}
\usage{
setParms(odeModel, parms)

\S4method{setParms}{odeModel,numeric}(odeModel, parms)
}
\arguments{
\item{odeModel}{an object of the class odeModel}

\item{parms}{a vector containing the parameters of the model}
}
\value{
an object of odeModel
}
\description{
A method to set the model parameters of an odeModel object.
}
\examples{
data("uvbModel")

newParas <- c(  ks1=0.23,
ks2=4.0526,
kdr1=0.1,
kdr2=0.2118,
k1=0.0043,
k2=161.62,
ka1=0.0372,
ka2=0.0611,
ka3=4.7207,
kd1=94.3524,
kd2=50.6973,
kd3=0.5508,
ks3=0.4397,
kdr3=1.246,
uv=1,
ka4=10.1285,
kd4=1.1999,
n1=3,
n2=2,
n3=3.5,
kdr3a=0.9735,
kdr3b=0.406,
ksr=0.7537,
fhy3_s=5)

newModel <- setParms(odeModel = uvbModel, parms = newParas)

}
