% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rscripts.R
\name{simf1gl}
\alias{simf1gl}
\title{Simulate genotype likelihoods of F1 individuals.}
\usage{
simf1gl(n, g1, g2, rd = 10, alpha = 0, xi1 = 1/3, xi2 = 1/3)
}
\arguments{
\item{n}{Sample size.}

\item{g1}{The first parent's genotype.}

\item{g2}{The second parent's genotype.}

\item{rd}{The read depth.}

\item{alpha}{The double reduction rate.}

\item{xi1}{The first parent's preferential pairing parameter.}

\item{xi2}{The second parent's preferential pairing parameter.}
}
\value{
The matrix of offspring genotype log-likelihoods.
}
\description{
Simulate genotype likelihoods of F1 individuals.
}
\examples{
set.seed(1)
simf1gl(n = 10, g1 = 1, g2 = 2)

}
\author{
David Gerard
}
