% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/create_database.R
\name{create_database}
\alias{create_database}
\title{Creating database}
\usage{
create_database(dbname, user, password, host)
}
\arguments{
\item{dbname}{name of database}

\item{user}{name of user}

\item{password}{password of database}

\item{host}{name of host}
}
\value{
invisible NULL
}
\description{
Function \code{create_database} creates a database with four empty
tables: deputies, votings, votes, statements.
}
\details{
\preformatted{
Created tables:
1. deputies with columns:
    1) id_deputy - deputy's id,
    2) surname_name - deputy's names and surnames,
2. votings with columns:
    1) id_voting - voting's id,
    2) nr_meeting - meeting's number,
    3) date_meeting - meeting's date,
    4) nr_voting - voting's number,
    5) topic_voting - voting's topic,
    6) link_results - link with voting's results,
3. votes with columns:
    1) id_vote - vote's id,
    2) id_deputy - deputy's id,
    3) id_voting - voting's id,
    4) vote - deputy's vote, one of: 'Za','Przeciw',
              'Wstrzymal sie','Nieobecny',
    5) club - deputy's club,
4. statements with columns:
    1) id_statement - statement's id, like:
    (meeting's number).(voting's number).(statement's number),
    2) surname_name - author of statement,
    3) date_statement - statement's date,
    4) statement - content of statement.}
}
\note{
All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
create_database(dbname, user, password, host)}
}
\author{
Piotr Smuda
}

