% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selon.R
\name{SelonOptimize}
\alias{SelonOptimize}
\title{Optimize parameters under the SELON model}
\usage{
SelonOptimize(nuc.data.path, n.partitions = NULL, phy,
  edge.length = "optimize", edge.linked = TRUE,
  optimal.nuc = "majrule", nuc.model = "GTR", set.Ne = 10000,
  diploid = TRUE, verbose = FALSE, n.cores = 1,
  max.tol = .Machine$double.eps^0.25, max.evals = 1e+06,
  cycle.stage = 12, max.restarts = 3, user.optimal.nuc = NULL,
  output.by.restart = TRUE, output.restart.filename = "restartResult",
  user.supplied.starting.param.vals = NULL, fasta.rows.to.keep = NULL,
  recalculate.starting.brlen = TRUE, dt.threads = 1)
}
\arguments{
\item{nuc.data.path}{Provides the path to the directory containing the gene specific fasta files that contains the nucleotide data.}

\item{n.partitions}{The number of partitions to analyze. The order is based on the Unix order of the fasta files in the directory.}

\item{phy}{The phylogenetic tree to optimize the model parameters.}

\item{edge.length}{Indicates whether or not edge lengths should be optimized. By default it is set to "optimize", other option is "fixed", which user-supplied branch lengths.}

\item{edge.linked}{A logical indicating whether or not edge lengths should be optimized separately for each gene. By default, a single set of each lengths is optimized for all genes.}

\item{optimal.nuc}{Indicates what type of optimal.nuc should be used. At the moment there is only a single option: "majrule".}

\item{nuc.model}{Indicates what type nucleotide model to use. There are three options: "JC", "GTR", or "UNREST".}

\item{set.Ne}{Indicates whether Ne is to estimated or a fixed value is to be used. Either a fixed value is supplied or "optimize" is use to indicate that it is a parameter to optimize.}

\item{diploid}{A logical indicating whether or not the organism is diploid or not.}

\item{verbose}{Logical indicating whether each iteration be printed to the screen.}

\item{n.cores}{The number of cores to run the analyses over.}

\item{max.tol}{Supplies the relative optimization tolerance.}

\item{max.evals}{Supplies the max number of iterations tried during optimization.}

\item{cycle.stage}{Specifies the number of cycles per restart. Default is 12.}

\item{max.restarts}{Supplies the number of random restarts.}

\item{user.optimal.nuc}{If optimal.nuc is set to "user", this option allows for the user-input optimal amino acids. Must be a list. To get the proper order of the partitions see "GetPartitionOrder" documentation.}

\item{output.by.restart}{Logical indicating whether or not each restart is saved to a file. Default is TRUE.}

\item{output.restart.filename}{Designates the file name for each random restart.}

\item{user.supplied.starting.param.vals}{Designates user-supplied starting values for C.q.phi.Ne, Grantham alpha, and Grantham beta. Default is NULL.}

\item{fasta.rows.to.keep}{Indicates which rows to remove in the input fasta files.}

\item{recalculate.starting.brlen}{Whether to use given branch lengths in the starting tree or recalculate them.}

\item{dt.threads}{Indicates how many available threads to allow data.table to use. Default is zero.}
}
\description{
Optimizes model parameters under the SELON model
}
\details{
SELON stands for SELection On Nucleotides. This function takes a user supplied topology and a set of fasta formatted sequences and optimizes the parameters in the SELON model. Selection is based on selection towards an optimal nucleotide at each site, which is based simply on the majority rule of the observed data. The strength of selection is then varied along sites based on a Taylor series, which scales the substitution rates.
}
