% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectSNPs_utility.R
\docType{methods}
\name{as.Map}
\alias{as.Map}
\alias{as.Map,list-method}
\alias{as.Map,data.frame-method}
\title{Convert a Data Frame to a \code{Map} Object.}
\usage{
as.Map(object)

\S4method{as.Map}{list}(object)

\S4method{as.Map}{data.frame}(object)
}
\arguments{
\item{object}{An input object, which can be either a data frame or a list of Chrom objects.}
}
\value{
An \code{Map} object.
}
\description{
This S4 function convert or creates a \code{Map} object. The input can be either a data frame or
a list of \code{Chrom} objects. If the data for minor allele frequency (Maf) are missing in the
input, their values are to be NAs. The default values for "Type" and "Status" are "C" and 0,
repectivelyl, if they are missing in the input.
}
\examples{
tmpdat<-as.data.frame(bov80K)
class(tmpdat)
tmpmap<-as.Map(tmpdat)
class(tmpmap)

}
\author{
Nick X-L Wu
}
