% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{is_visible}
\alias{is_visible}
\alias{is_displayed}
\alias{is_hidden}
\alias{is_invisible}
\title{Is an element visible?}
\usage{
is_visible(x)

is_displayed(x)

is_hidden(x)

is_invisible(x)
}
\arguments{
\item{x}{A \code{selenider_element} object.}
}
\value{
A boolean value: TRUE or FALSE.
}
\description{
\code{is_visible()} and \code{is_displayed()} checks that an element can be seen on the
page, while \code{is_invisible()} and \code{is_hidden()} checks the opposite. All
functions throw an error if the element is not in the DOM.
}
\details{
These functions do not implement a retry mechanism, and only test a condition
once. Use \code{\link[=elem_expect]{elem_expect()}} or \code{\link[=elem_wait_until]{elem_wait_until()}} to use these conditions in
tests.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div style='visibility:hidden;'>Content 1</div>
<div style='display:none'>Content 2</div>
<div>Content 3</div>
"

session <- minimal_selenider_session(html)

is_visible(s("div")) # FALSE

is_invisible(ss("div")[[2]]) # TRUE

is_visible(ss("div")[[3]]) # TRUE
\dontshow{\}) # examplesIf}
}
\seealso{
Other conditions: 
\code{\link{has_attr}()},
\code{\link{has_css_property}()},
\code{\link{has_length}()},
\code{\link{has_name}()},
\code{\link{has_text}()},
\code{\link{is_enabled}()},
\code{\link{is_present}()}
}
\concept{conditions}
