% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{selenider_available}
\alias{selenider_available}
\alias{skip_if_selenider_unavailable}
\title{Check if selenider can be used}
\usage{
selenider_available(
  session = c("chromote", "selenium", "rselenium"),
  online = TRUE
)

skip_if_selenider_unavailable(session = c("chromote", "selenium"))
}
\arguments{
\item{session}{Which session we should check. \code{"chromote"} is used by
default.}

\item{online}{Whether we need to check for an internet connection.}
}
\value{
A boolean flag: \code{TRUE} or \code{FALSE}.
}
\description{
Checks if selenider's dependencies are available, and that we are in an
environment where it makes sense to open a selenider session.

\code{skip_if_selenider_unavailable()} skips a testthat test if
\code{selenider_available()} returns \code{FALSE}.
}
\details{
Specifically, the following is checked:
\itemize{
\item The \code{SELENIDER_AVAILABLE} environment variable. Set this to \code{"TRUE" }or
\code{"FALSE"} to override this function.
\item Whether we are on CRAN (using the \code{NOT_CRAN} environment variable). If we
are, the function returns \code{FALSE}.
\item Whether an internet connection is available (using \code{\link[curl:nslookup]{curl::nslookup()}}).
}

If \code{session} is \code{"chromote"}, we also check:
\itemize{
\item Whether \code{chromote} is installed.
\item Whether \code{\link[chromote:find_chrome]{chromote::find_chrome()}} does not error.
}

If \code{session} is \code{"selenium"}, we check:
\itemize{
\item Whether \code{selenium} is installed.
\item Whether we can find a valid browser that is supported by \code{RSelenium}.
}
}
\examples{
selenider_available()

}
