% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_index_plot.R
\name{index_plot}
\alias{index_plot}
\title{Index Plot of an Arbitrary Statistic}
\usage{
index_plot(
  object,
  column = NULL,
  plot_title = "Index Plot",
  x_label = NULL,
  cutoff_x_low = NULL,
  cutoff_x_high = NULL,
  largest_x = 1,
  absolute = FALSE,
  point_aes = list(),
  vline_aes = list(),
  hline_aes = list(),
  cutoff_line_aes = list(),
  case_label_aes = list()
)
}
\arguments{
\item{object}{A matrix-like object,
such as the output from
\code{\link[=influence_stat]{influence_stat()}}, \code{\link[=est_change]{est_change()}},
\code{\link[=est_change_raw]{est_change_raw()}}, and their
counterparts for the approximate
approach.}

\item{column}{String. The column
name of the values to be plotted.}

\item{plot_title}{The title of the
plot. Default is \code{"Index Plot"}.}

\item{x_label}{The Label for the
vertical axis, for the value of
\code{column}. Default is \code{NULL}.
If \code{NULL}, then the label is
changed to
\code{"Statistic"} if \code{absolute} is
\code{FALSE}, and \code{"Absolute(Statistics)"}
if \code{absolute} is \code{TRUE}.}

\item{cutoff_x_low}{Cases with values
smaller than this value will be labeled.
A cutoff line will be drawn at this
value.
Default is \code{NULL}. If \code{NULL}, no
cutoff line will be drawn for this
value.}

\item{cutoff_x_high}{Cases with values
larger than this value will be labeled.
A cutoff line will be drawn at this
value.
Default is \code{NULL}. If \code{NULL}, no
cutoff line will be drawn for this
value.}

\item{largest_x}{The number of cases
with the largest absolute value on
`column``
to be labelled. Default is 1. If not
an integer, it will be rounded to the
nearest integer.}

\item{absolute}{Whether absolute values
will be plotted. Useful when cases
are to be compared on magnitude,
ignoring sign. Default is \code{FALSE}.}

\item{point_aes}{A named list of
arguments to be passed to
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} to modify how
to draw the points. Default is
\code{list()} and internal default
settings will be used.}

\item{vline_aes}{A named list of
arguments to be passed to
\code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}} to modify how
to draw the line for each case
in the index plot. Default is
\code{list()} and internal default
settings will be used.}

\item{hline_aes}{A named list of
arguments to be passed to
\code{\link[ggplot2:geom_abline]{ggplot2::geom_hline()}} to modify how
to draw the horizontal line for zero
case influence. Default is \code{list()}
and internal default settings will be
used.}

\item{cutoff_line_aes}{A named list
of arguments to be passed to
\code{\link[ggplot2:geom_abline]{ggplot2::geom_hline()}} to modify how
to draw the line for user cutoff
values. Default is \code{list()}
and internal default settings will be
used.}

\item{case_label_aes}{A named list of
arguments to be passed to
\code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel()}} to
modify how to draw the labels for
cases marked (based on arguments
such as \code{cutoff_x_low} or \code{largest_x}).
Default is \code{list()} and internal
default settings will be used.}
}
\value{
A \link{ggplot2} plot. Plotted by
default. If assigned to a variable
or called inside a function, it will
not be plotted. Use \code{\link[=plot]{plot()}} to
plot it.
}
\description{
A generic index plot
function for plotting values of
a column # in a matrix.
}
\details{
This index plot function
is for plotting any measure of
influence or extremeness in a matrix.
It can be used for measures not supported
with other functions.

Like functions such as \code{\link[=gcd_plot]{gcd_plot()}}
and \code{\link[=est_change_plot]{est_change_plot()}}, it supports
labelling cases based on the values
on the selected measure
(originaL values or absolute values).

Users can also plot cases based on
the absolute values. This is useful
when cases are to be compared on
magnitude, ignoring the sign.
}
\examples{
library(lavaan)
dat <- pa_dat
# The model
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)

# --- Leave-One-Out Approach

# Fit the model n times. Each time with one case removed.
# For illustration, do this only for selected cases.
fit_rerun <- lavaan_rerun(fit, parallel = FALSE,
                          to_rerun = 1:10)
# Get all default influence stats
out <- influence_stat(fit_rerun)

# Plot case influence on chi-square. Label the 3 cases with the influence.
index_plot(out, "chisq", largest_x = 3)

# Plot absolute case influence on chi-square.
index_plot(out, "chisq", absolute = TRUE)

}
\seealso{
\code{\link[=influence_stat]{influence_stat()}}, \code{\link[=est_change]{est_change()}},
\code{\link[=est_change_raw]{est_change_raw()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}.
}
