% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap_model}
\alias{bootstrap_model}
\title{seminr bootstrap_model Function}
\usage{
bootstrap_model(seminr_model, nboot = 500, cores = NULL, ...)
}
\arguments{
\item{seminr_model}{A fully estimated model with associated data, measurement model and structural model}

\item{nboot}{A parameter specifying the number of bootstrap iterations to perform, default
value is 500. If 0 then no bootstrapping is performed.}

\item{cores}{A parameter specifying the maximum number of cores to use in the parallelization.}

\item{...}{A list of parameters passed on to the estimation method (e.g., \code{simplePLS}).}
}
\description{
The \code{seminr} package provides a natural syntax for researchers to describe PLS
structural equation models. \code{seminr} is compatible with simplePLS.
\code{bootstrap_model} provides the verb for bootstrapping a pls model from the model
parameters and data.
}
\examples{
data(mobi)
# seminr syntax for creating measurement model
mobi_mm <- constructs(
  composite("Image",        multi_items("IMAG", 1:5)),
  composite("Expectation",  multi_items("CUEX", 1:3)),
  composite("Value",        multi_items("PERV", 1:2)),
  composite("Satisfaction", multi_items("CUSA", 1:3))
)

# interaction factors must be created after the measurement model is defined
mobi_xm <- interactions(
  interaction_ortho("Image", "Expectation"),
  interaction_ortho("Image", "Value")
)

# structural model: note that name of the interactions factor should be
#  the names of its two main factors joined by a '.' in between.
mobi_sm <- relationships(
  paths(to = "Satisfaction",
        from = c("Image", "Expectation", "Value",
                 "Image.Expectation", "Image.Value"))
)

seminr_model <- estimate_pls(data = mobi,
                             measurement_model = mobi_mm,
                             interactions = mobi_xm,
                             structural_model = mobi_sm)

# Load data, assemble model, and bootstrap using simplePLS
boot_seminr_model <- bootstrap_model(seminr_model = seminr_model,
                                     nboot = 50, cores = 2)

summary(boot_seminr_model)
}
\references{
Hair, J. F., Hult, G. T. M., Ringle, C. M., and Sarstedt, M. (2017). A Primer on Partial Least Squares
 Structural Equation Modeling (PLS-SEM), 2nd Ed., Sage: Thousand Oaks.
}
\seealso{
\code{\link{relationships}} \code{\link{constructs}} \code{\link{paths}} \code{\link{interactions}}
}
