% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{report_paths}
\alias{report_paths}
\alias{plot_scores}
\title{Functions for reporting the Path Coefficients and R2 of endogenous constructs
and for generating a scatterplot matrix of factor scores.}
\usage{
report_paths(seminr_model, digits=3)

plot_scores(seminr_model, factors=NULL)
}
\arguments{
\item{seminr_model}{The PLS model estimated by simplePLS \code{seminr}. The estimated model
returned by the \code{estimate_pls} or \code{bootstrap_model} methods.}

\item{digits}{A \code{numeric} minimum number of significant digits. If not
specified, default is "2".}

\item{factors}{a \code{list} indicating which factors to report. If not
specified, all factors are graphed and returned.}
}
\description{
\code{report_paths} generates an easy to read table reporting path coefficients
  and R2 values for endogenous constructs.\code{plot_scores} generates a
  scatterplot matrix of each factor's scores against every other factor's scores.
}
\details{
These functions generate an easy to read table reporting path coefficients
  and R2 values for endogenous constructs or a scatterplot matrix of factor
  scores.
}
\examples{
data(mobi)

# seminr syntax for creating measurement model
mobi_mm <- constructs(
  composite("Image",        multi_items("IMAG", 1:5)),
  composite("Expectation",  multi_items("CUEX", 1:3)),
  composite("Value",        multi_items("PERV", 1:2)),
  composite("Satisfaction", multi_items("CUSA", 1:3))
)

#  structural model: note that name of the interactions factor should be
#  the names of its two main factors joined by a '.' in between.
mobi_sm <- relationships(
  paths(to = "Satisfaction",
        from = c("Image", "Expectation", "Value"))
)

mobi_pls <- estimate_pls(mobi, measurement_model = mobi_mm, structural_model = mobi_sm)
report_paths(mobi_pls)
plot_scores(mobi_pls)

}
