% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pls.R
\name{rerun.pls_model}
\alias{rerun.pls_model}
\title{Reruns a previously specified seminr PLS model}
\usage{
\method{rerun}{pls_model}(x, ...)
}
\arguments{
\item{x}{An estimated pls_model object produced by \code{\link{estimate_pls}}}

\item{...}{Any parameters to change during the re-estimation (e.g., data, measurement_model, etc.)}
}
\value{
A re-estimated pls_model object
}
\description{
Reruns a previously specified seminr PLS model
}
\examples{

mobi <- mobi

mobi_mm <- constructs(
  composite("Image",        multi_items("IMAG", 1:5)),
  composite("Loyalty",      multi_items("CUSL", 1:3))
)

mobi_sm <- relationships(
  paths(from = "Image",        to = c("Loyalty"))
)

mobi_pls <- estimate_pls(data = mobi,
                         measurement_model = mobi_mm,
                         structural_model = mobi_sm,
                         missing = mean_replacement,
                         missing_value = NA)

# Re-estimate model faithfully
mobi_pls2 <- rerun(mobi_pls)

# Re-estimated model with altered measurement model
mobi_pls3 <- rerun(mobi_pls, measurement_model=as.reflective(mobi_mm))

}
