% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_message.R
\name{print_message}
\alias{print_message}
\title{Print a message}
\usage{
print_message(..., type, sep = "", date = FALSE, date_format = "")
}
\arguments{
\item{...}{\code{R} objects which are concatenated.}

\item{type}{Type of the output .Accepted values:
\itemize{
\item 'message' for a diagnostic message;
\item 'string' for a character output;
\item 'cat' for the output of \code{\link[base]{cat}} function;
\item 'error' and 'warning' for an error or warning message.
}

Intentionally, no default value is defined.}

\item{sep}{(optional) character used to separate input values
(default is nothing).}

\item{date}{Logical value: set TRUE to place the date before the message
(useful for logs or time consuming operations); default is FALSE.}

\item{date_format}{Format of the date (see \code{\link[base]{strftime}})
for the definition of the format). The default format is
"\%Y-\%m-\%d \%H:\%M:\%S".}
}
\value{
Message (in the defined format).
}
\description{
A common interface for printing messages of several types.
}
\details{
Several functions print messages in different formats
(message, error, warning, cat, R output) and with different syntaxes
(concatenating parameters or accepting a single argument, appending
a new line, etc.).
This accessory function provides a common interface for different types:
several arguments are accepted and concatenated with the \code{sep} argument;
the format is defined with the \code{format} argument; a date is optionally
placed before the message.
}
\note{
License: GPL 3.0
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
