% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_phyglm.R
\name{tree_phyglm}
\alias{tree_phyglm}
\title{Phylogenetic uncertainty - Phylogenetic Logistic Regression}
\usage{
tree_phyglm(formula, data, phy, times = 2, btol = 50, track = TRUE, ...)
}
\arguments{
\item{formula}{The model formula}

\item{data}{Data frame containing species traits with species as row names.}

\item{phy}{A phylogeny (class 'multiPhylo', see ?\code{ape}).}

\item{times}{Number of times to repeat the analysis with n different trees picked 
randomly in the multiPhylo file.
If NULL, \code{times} = 2}

\item{btol}{Bound on searching space. For details see \code{phyloglm}.}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{phyloglm}}
}
\value{
The function \code{tree_phyglm} returns a list with the following
components:

\code{formula}: The formula

\code{data}: Original full dataset

\code{model_results}: Coefficients, aic and the optimised
value of the phylogenetic parameter (e.g. \code{lambda}) for each regression with a 
different phylogenetic tree.

\code{N.obs}: Size of the dataset after matching it with tree tips and removing NA's.

\code{stats}: Main statistics for model parameters.\code{CI_low} and \code{CI_high} are the lower 
and upper limits of the 95% confidence interval.

\code{all.stats}: Complete statistics for model parameters. \code{sd_intra} is the standard deviation 
due to intraspecific variation. \code{CI_low} and \code{CI_high} are the lower and upper limits 
of the 95% confidence interval.
}
\description{
Performs Phylogenetic logistic regression evaluating
uncertainty in trees topology.
}
\details{
This function fits a phylogenetic linear regression model using \code{\link[phylolm]{phyloglm}}
to n trees, randomly picked in a multiPhylo file.

Currently, this function can only implement simple logistic models (i.e. \eqn{trait~
predictor}). In the future we will implement more complex models.

Output can be visualised using \code{sensi_plot}.
}
\examples{
### Simulating Data:
set.seed(6987)
mphy = rmtree(150, N = 30)
x = rTrait(n=1,phy=mphy[[1]])
X = cbind(rep(1,150),x)
y = rbinTrait(n=1,phy=mphy[[1]], beta=c(-1,0.5), alpha=.7 ,X=X)
dat = data.frame(y, x)
# Run sensitivity analysis:
tree <- tree_phyglm(y ~ x, data = dat, phy = mphy, times = 30)
# summary results:
summary(tree)
# Visual diagnostics for phylogenetic uncertainty:
sensi_plot(tree)
}
\author{
Caterina Penone & Pablo Ariel Martinez
}
\references{
Donoghue, M.J. & Ackerly, D.D. (1996). Phylogenetic Uncertainties and 
Sensitivity Analyses in Comparative Biology. Philosophical Transactions:
 Biological Sciences, pp. 1241-1249.
 
Ho, L. S. T. and Ane, C. 2014. "A linear-time algorithm for 
Gaussian and non-Gaussian trait evolution models". Systematic Biology 63(3):397-408.
}
\seealso{
\code{\link[phylolm]{phyloglm}}, \code{\link{sensi_plot}}
}

