% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_physig.R
\name{tree_physig}
\alias{tree_physig}
\title{Phylogenetic uncertainty - Phylogenetic signal}
\usage{
tree_physig(trait.col, data, phy, n.tree = "all", method = "K",
  track = TRUE, ...)
}
\arguments{
\item{trait.col}{The name of a column in the provided data frame with trait 
to be analyzed  (e.g. "Body_mass").}

\item{data}{Data frame containing species traits with row names matching tips
in \code{phy}.}

\item{phy}{A phylogeny (class 'phylo') matching \code{data}.}

\item{n.tree}{Number of times to repeat the analysis with n different trees picked 
randomly in the multiPhylo file. (If \code{n.tree} = "all", phylosgentic signal will be estimated
among the all set of trees provided in \code{phy})}

\item{method}{Method to compute signal: can be "K" or "lambda".}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{phylosig}}
}
\value{
The function \code{tree_physig} returns a list with the following
components:

\code{Trait}: Column name of the trait analysed

\code{data}: Original full dataset

\code{tree.physig.estimates}: Three number, phylogenetic signal estimate 
(lambda or K) and the p-value for each run with a different phylogenetic tree.

\code{N.obs}: Size of the dataset after matching it with tree tips and removing NA's.

\code{stats}: Main statistics for phylogenetic estimates.\code{CI_low} and \code{CI_high} are the lower 
and upper limits of the 95% confidence interval.
}
\description{
Performs phylogenetic signal estimates evaluating
uncertainty in trees topology.
}
\details{
This function estimates phylogenetic signal using \code{\link[phytools]{phylosig}}
to n trees, randomly picked in a multiPhylo file.

Output can be visualised using \code{sensi_plot}.
}
\examples{
# Load data:
data(alien)
# Logtransform data
alien.data$logMass <- log(alien.data$adultMass) 
# Run sensitivity analysis:
tree <- tree_physig(trait.col = "logMass", data = alien.data, 
phy = alien.phy, n.tree = 10)
summary(tree)
sensi_plot(tree)
sensi_plot(tree, graphs = 1)
sensi_plot(tree, graphs = 2)
}
\references{
Donoghue, M.J. & Ackerly, D.D. (1996). Phylogenetic Uncertainties and 
Sensitivity Analyses in Comparative Biology. Philosophical Transactions:
 Biological Sciences, pp. 1241-1249.
 
Blomberg, S. P., T. Garland Jr., A. R. Ives (2003) 
Testing for phylogenetic signal in comparative data: 
Behavioral traits are more labile. Evolution, 57, 717-745.

Pagel, M. (1999) Inferring the historical patterns of biological evolution. 
Nature, 401, 877-884.

Kamilar, J. M., & Cooper, N. (2013). Phylogenetic signal in primate behaviour,
 ecology and life history. Philosophical Transactions of the Royal Society 
 B: Biological Sciences, 368: 20120341.
}
\seealso{
\code{\link[phytools]{phylosig}}, 
\code{\link{tree_phylm}},\code{\link{sensi_plot}}
}
\author{
Caterina Penone & Gustavo Paterno
}
