% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_rating.R
\name{replace_rating}
\alias{replace_rating}
\title{Replace Ratings With Words}
\usage{
replace_rating(text.var, rating_dt = sentimentr::ratings, ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{rating_dt}{A \pkg{data.table} of ratings and corresponding word meanings.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector of strings with ratings replaced with word
equivalents.
}
\description{
Replaces ratings with word equivalents.
}
\examples{
x <- c("This place receives 5 stars for their APPETIZERS!!!",
     "Four stars for the food & the guy in the blue shirt for his great vibe!",
     "10 out of 10 for both the movie and trilogy.",
     "* Both the Hot & Sour & the Egg Flower Soups were absolutely 5 Stars!",
     "For service, I give them no stars.", "This place deserves no stars.",
     "10 out of 10 stars.",
     "My rating: just 3 out of 10.",
     "If there were zero stars I would give it zero stars.",
     "Rating: 1 out of 10.",
     "I gave it 5 stars because of the sound quality.",
     "If it were possible to give them 0/10, they'd have it."
)

replace_rating(x)
}
\keyword{rating}

