% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{weights_exponential}
\alias{weights_exponential}
\title{Compute exponential weighting curves}
\usage{
weights_exponential(n, alphas = seq(0.1, 0.5, by = 0.1),
  do.inverse = FALSE, do.normalize = TRUE)
}
\arguments{
\item{n}{a single \code{numeric} to indicate the lag length.}

\item{alphas}{a \code{numeric} vector of decay factors, between 0 and 1, but multiplied by 10 in
the implementation.}

\item{do.inverse}{\code{TRUE} if the inverse exponential curves should be calculated as well.}

\item{do.normalize}{a \code{logical}, if \code{TRUE} weights are normalized to unity.}
}
\value{
A \code{data.frame} of exponential weighting curves per value of \code{alphas}.
}
\description{
Computes exponential weighting curves. Handy to self-select specific time aggregation weighting schemes
for input in \code{\link{ctr_agg}} using the \code{weights} argument.
}
\seealso{
\code{\link{ctr_agg}}
}
