% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange_se.R
\name{arrange_se}
\alias{arrange_se}
\title{Arrange standard interface.}
\usage{
arrange_se(.data, arrangeTerms, ..., .by_group = FALSE, strict = TRUE)
}
\arguments{
\item{.data}{data.frame}

\item{arrangeTerms}{character vector of column expressions to arrange by.}

\item{...}{not used, force later arguments to bind by name.}

\item{.by_group}{logical, should data be sorted by grouping variables (if present).}

\item{strict}{logical if TRUE accept only name and desc(name) terms.}
}
\value{
.data arrnaged by arrangeTerms
}
\description{
Arrange a data frame by the possibly the \code{group_vars()} (optional, but defaults to off) and \code{arrangeTerms}.  Accepts arbitrary text as
arrangeTerms to allow forms such as "desc(gear)". Intent is to arrange only by
sets of variables with desc() notations reversals, not by arbitrary expressions over variables.
To help enforce this parsing is performed in an empty environment (so expressions
such as "gear + carb" deliberately error-out).
}
\examples{

datasets::mtcars \%.>\%
  arrange_se(., c("cyl", "desc(gear)")) \%.>\%
  head(.)
# equivilent to dplyr/magrittr pipeline
# arrange(datasets::mtcars, cyl, desc(gear)) \%>\% head()

# Note: arranging in the presence of groups is subtle.
# As grouping is an annotation, not an ordering (and ordering is
# unfortunately not an annotation).

d <- data.frame(x = 1:6,
                sin_x = sin(1:6),
                grp = rep(c("a", "b"), 3),
                stringsAsFactors = FALSE)

# arranged by sin_x and not by grp
d \%.>\%
  group_by_se(., "grp") \%.>\%
  arrange_se(., "sin_x")

# arranged by sin_x and not by grp
d \%.>\%
  arrange_se(., "sin_x") \%.>\%
  group_by_se(., "grp")

# arranged by sin_x and not by grp
d \%.>\%
  group_by_se(., "grp") \%.>\%
  arrange_se(., "sin_x", .by_group = TRUE)

# arranged by sin_x and not by grp
d \%.>\%
  arrange_se(., "sin_x", .by_group = TRUE) \%.>\%
  group_by_se(., "grp")

}
\seealso{
\code{\link[dplyr]{arrange}}, \code{\link[dplyr]{arrange_at}}
}
