% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute.R
\name{est_sv}
\alias{est_sv}
\title{Estimate the surrogate variables.}
\usage{
est_sv(mat, n_sv, design_obs, use_sva = FALSE)
}
\arguments{
\item{mat}{A numeric matrix of RNA-seq counts. The rows index the genes and
the columns index the samples.}

\item{n_sv}{The number of surrogate variables.}

\item{design_obs}{A numeric matrix of observed covariates that are NOT to
be a part of the signal generating process. Only used in estimating the
surrogate variables (if \code{target_cor} is not \code{NULL}).
The intercept should \emph{not} be included (it will sometimes
produce an error if it is included).}

\item{use_sva}{A logical. Should we use surrogate variable analysis
(Leek and Storey, 2008) using \code{design_obs}
to estimate the hidden covariates (\code{TRUE})
or should we just do an SVD on \code{log2(mat + 0.5)} after
regressing out \code{design_obs} (\code{FALSE})? Setting this to
\code{TRUE} allows the surrogate variables to be correlated with the
observed covariates, while setting this to \code{FALSE} assumes that
the surrogate variables are orthogonal to the observed covariates. This
option only matters if \code{design_obs} is not \code{NULL}.
Defaults to \code{FALSE}.}
}
\value{
A matrix of estimated surrogate variables. The columns index the
    surrogate variables and the rows index the individuals. The surrogate
    variables are centered and scaled to have mean 0 and variance 1.
}
\description{
This will use either \code{\link[sva]{sva}} or an SVD on the residuals
of a regression of \code{mat} on \code{design_obs} to estimate the
surrogate variables.
}
\author{
David Gerard
}
