% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqminer.R
\name{readBGENToMatrixByRange}
\alias{readBGENToMatrixByRange}
\title{Read a gene from BGEN file and return a genotype matrix}
\usage{
readBGENToMatrixByRange(fileName, range)
}
\arguments{
\item{fileName}{character, represents an input BGEN file (Bgzipped, with Tabix index)}

\item{range}{character, a text indicating which range in the BGEN file to extract. e.g. 1:100-200}
}
\value{
genotype matrix
}
\description{
Read a gene from BGEN file and return a genotype matrix
}
\examples{
fileName = system.file("bgen/all.anno.filtered.extract.bgen", package = "seqminer")
cfh <- readBGENToMatrixByRange(fileName, "1:196621007-196716634")
}
\seealso{
http://zhanxw.com/seqminer/ for online manual and examples
}
