% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PairRelation.R
\name{GetRelCat}
\alias{GetRelCat}
\title{Pairwise relationship}
\usage{
GetRelCat(x, Ped, GenBack = 2)
}
\arguments{
\item{x}{The focal individual, either its rownumber in the pedigreee or ID.}

\item{Ped}{dataframe with pedigree; columns id - dam - sire.}

\item{GenBack}{Number of generations back to consider; 1 returns
parent-offspring and sibling relationships, 2 also returns grandparental,
avuncular and first cousins.}
}
\value{
A named vector of length equal to the number of rows in Ped, with for
  each ID its relationship to the focal individual:
   \item{S}{Self}
   \item{M}{Mother}
   \item{P}{Father}
   \item{O}{Offspring}
   \item{FS}{Full sibling}
   \item{MHS}{Maternal half-sibling}
   \item{PHS}{Paternal half-sibling}
   \item{MGM}{Maternal grandmother}
   \item{MGF}{Maternal grandfather}
   \item{PGM}{Paternal grandmother}
   \item{PGF}{Paternal grandfather}
   \item{GO}{Grand-offspring}
   \item{FA}{Full avuncular; maternal or paternal aunt or uncle}
   \item{HA}{Half avuncular}
   \item{FN}{Full nephew/niece}
   \item{HN}{Half nephew/niece}
   \item{FC1}{Full first cousin}
   \item{DFC1}{Double full first cousin}
   \item{U}{Unrelated (or otherwise related)}
}
\description{
Determine the relationship between individual X and all other
  individuals in the pedigree, going up to 1 or 2 generations back.
}
\details{
if
}
\examples{
\dontrun{
# make NxN matrix with relationship categories:
RCM <- sapply(1:nrow(Ped), GetRelCat, Ped)
# table is considerably faster on a factor than a character vector:
table(factor(RCM, levels=c("M","P","FS","MHS","PHS","MGM")))
# note that sibling & cousin pairs are counted twice!
}

}
