% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctas-profile.R
\name{ctas_profile}
\alias{ctas_profile}
\title{Generate a Drill CTAS Statement from a Query}
\usage{
ctas_profile(x, new_table_name = "CHANGE____ME")
}
\arguments{
\item{x}{a \code{tbl}}

\item{new_table_name}{a new Drill data source spec (e.g. \code{dfs.xyz.`a.parquet`})}
}
\description{
When working with CSV[H] files in Drill 1.15.0+ everything comes back
\code{VARCHAR} since that's the way it should be. The old behaviour of
\code{sergeant} to auto-type convert was kinda horribad wrong. However,
it's a royal pain to make \href{https://drill.apache.org/docs/create-table-as-ctas/}{\code{CTAS}}
queries from a giant list of \code{VARCHAR} field by hand. So, this is a
helper function to do that, inspired by David Severski.
}
\note{
WIP!
}
\examples{
\dontrun{
db <- src_drill("localhost")

# Test with bare data source
flt1 <- tbl(db, "dfs.d.`/flights.csvh`")

cat(ctas_profile(flt1))

# Test with SELECT
flt2 <- tbl(db, sql("SELECT `year`, tailnum, time_hour FROM dfs.d.`/flights.csvh`"))

cat(ctas_profile(flt2, "dfs.d.`flights.parquet`"))

}
}
