% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rest-api.r
\name{drill_connection}
\alias{drill_connection}
\title{Setup a Drill connection}
\usage{
drill_connection(
  host = Sys.getenv("DRILL_HOST", "localhost"),
  port = Sys.getenv("DRILL_PORT", 8047),
  ssl = FALSE,
  user = Sys.getenv("DRILL_USER", ""),
  password = Sys.getenv("DRILL_PASSWORD", "")
)
}
\arguments{
\item{host}{Drill host (will pick up the value from \code{DRILL_HOST} env var)}

\item{port}{Drill port (will pick up the value from \code{DRILL_PORT} env var)}

\item{ssl}{use ssl?}

\item{user, password}{(will pick up the values from \code{DRILL_USER}/\code{DRILL_PASSWORD} env vars)}
}
\description{
Setup a Drill connection
}
\note{
If \code{user}/\code{password} are set this function will make a \code{POST} to the REST
interface immediately to prime the cookie-jar with the session id.
}
\examples{
dc <- drill_connection()
}
\seealso{
Other Drill direct REST API Interface: 
\code{\link{drill_active}()},
\code{\link{drill_cancel}()},
\code{\link{drill_functions}()},
\code{\link{drill_metrics}()},
\code{\link{drill_options}()},
\code{\link{drill_opts}()},
\code{\link{drill_profiles}()},
\code{\link{drill_profile}()},
\code{\link{drill_query}()},
\code{\link{drill_settings_reset}()},
\code{\link{drill_set}()},
\code{\link{drill_stats}()},
\code{\link{drill_status}()},
\code{\link{drill_storage}()},
\code{\link{drill_system_reset}()},
\code{\link{drill_threads}()},
\code{\link{drill_version}()}
}
\concept{Drill direct REST API Interface}
