% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SupremeCourt.R
\docType{data}
\name{SupremeCourt}
\alias{SupremeCourt}
\title{Voting Patterns in the Second Rehnquist U.S. Supreme Court}
\format{
A square, symmetric 9-by-9 matrix with the joint probability for disagreement.
}
\description{
Contains a (a subset of the) decisions for the stable 8-yr
period 1995-2002 of the second Rehnquist Supreme Court.
Decisions are aggregated to
the joint probability for disagreement between judges.
}
\examples{
data("SupremeCourt")

SupremeCourt

d <- as.dist(SupremeCourt)
o <- seriate(d)

pimage(d, o)

plot(hclust(as.dist(SupremeCourt)))
}
\references{
\preformatted{Sirovich, L. (2003). A pattern analysis of the second Rehnquist
U.S. Supreme Court. \\emph\{Proceedings of the National Academy of Sciences of the United
States of America,\} 100, 7432-7437. \doi{10.1073/pnas.1132164100}
}
}
\author{
Michael Hahsler
}
\keyword{datasets}
