% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.seroincidence.R
\name{print.seroincidence}
\alias{print.seroincidence}
\title{Print Method for \code{seroincidence} Object}
\usage{
\method{print}{seroincidence}(x, ...)
}
\arguments{
\item{x}{A list containing output of function \code{\link[=est.incidence.by]{est.incidence.by()}}.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
A \code{list} containing the output of the function \code{est.incidence()}.
}
\description{
Custom \code{\link[=print]{print()}} function to show output of the seroincidence calculator \code{\link[=est.incidence]{est.incidence()}}.
}
\examples{

\donttest{

library(tidyverse)

xs_data <- load_pop_data("https://osf.io/download//n6cp3/") \%>\%
  clean_pop_data()

curve <- load_curve_params("https://osf.io/download/rtw5k/") \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG")) \%>\%
  slice(1:100, .by = antigen_iso) # Reduce dataset for the purposes of this example

noise <- load_noise_params("https://osf.io/download//hqy4v/")


est1 <- est.incidence(
  pop_data = xs_data \%>\% filter(Country == "Pakistan"),
  curve_param = curve,
  noise_param = noise \%>\% filter(Country == "Pakistan"),
  antigen_isos = c("HlyE_IgG", "HlyE_IgA")
)

print(est1)
}

}
