% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimateSeroincidence.R
\name{estimateSeroincidence}
\alias{estimateSeroincidence}
\title{Estimate Seroincidences}
\usage{
estimateSeroincidence(data, antibodies, strata = "", Ak, censorLimits,
  showProgress = FALSE, ...)
}
\arguments{
\item{data}{Dataframe with cross-sectional serum antibody data. At least one
antibody should be specified. Rows represent multiple antibody measurements
in the same serum sample. Strata may be specified in additional columns.}

\item{antibodies}{Character vector with names of antibodies to be included
for incidence calculations. At least one antibody name must be specified,
names must match with those in \code{data} and in \code{Ak}.}

\item{strata}{Character vector with names of strata to be used, default ="". Names
must match with data.}

\item{Ak}{List with two dataframes containing longitudinal parameters named
A (the peak serum antibody level) and k (the decay rate). Each dataframe
contains sets of Monte Carlo samples, one for each antibody that is available.}

\item{censorLimits}{List of cutoffs for each of the antibodies specified
in 'antibodies'. Any cross-sectional observations below cutoff will be treated
as censored at the cutoff level.}

\item{showProgress}{Indicator whether or not to show text progress bar indicating progress of estimation.
The setting is effective only if the number of levels per stratum if greater than 1. Default is \code{FALSE}.}

\item{...}{Additional arguments passed to function \code{\link{optim}}.}
}
\value{
A list with the following items:
\describe{
\item{\code{Fits}}{Outputs of \code{\link{optim}} function per stratum.}
\item{\code{Antibodies}}{Input parameter \code{antibodies} saved for \code{\link{summary}} function.}
\item{\code{Strata}}{Input parameter \code{strata} saved for \code{\link{summary}} function.}
\item{\code{CensorLimits}}{Input parameter \code{censorLimits} saved for \code{\link{summary}} function.}
}
}
\description{
Function to estimate seroincidences based on cross-section serology data and
longitudinal response model.
}
\examples{
\dontrun{
estimateSeroincidence(data = serologyData, antibodies = c("IgG", "IgM", "IgA"),
                         strata = c("age"), Ak = responseParams)
}
}

