% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sir_subpops_model.R
\name{sir_subpops_model}
\alias{sir_subpops_model}
\title{SIR Model with Interacting Subpopulations}
\usage{
sir_subpops_model(times, state, parameters)
}
\arguments{
\item{times}{time sequence.}

\item{state}{the initial state of the model.}

\item{parameters}{the parameters of the model.}
}
\value{
list of class sir_subpops_model with the following items

  \item{parameters}{list of parameters used for fitting the model}
  \item{output}{matrix of proportion for each compartment over time}
}
\description{
Refers to section 3.5.1.
}
\details{
In \code{state}:

- \code{s}: Percent susceptible

- \code{i}: Percent infected

- \code{r}: Percent recovered

In \code{parameters}:

- \code{mu}: natural death rate (1/L).

- \code{beta}: transmission rate w.r.t population (beta tilde)

- \code{nu}: recovery rate

- \code{k}: number of subpopulations
}
\examples{
\donttest{
k <- 2
state <- c(
  s = c(0.8, 0.8),
  i = c(0.2, 0.2),
  r = c(  0,   0)
)
beta_matrix <- c(
  c(0.05, 0.00),
  c(0.00, 0.05)
)
parameters <- list(
  beta = matrix(beta_matrix, nrow=k, ncol=k, byrow=TRUE),
  nu = c(1/30, 1/30),
  mu = 0.001,
  k = k
)
times<-seq(0,10000,by=0.5)
model <- sir_subpops_model(times, state, parameters)
model
}

}
