% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitSpectraMCMC.R
\name{fitSpectraMCMC}
\alias{fitSpectraMCMC}
\title{Fit the model using Markov chain Monte Carlo.}
\usage{
fitSpectraMCMC(wl, spc, peakWL, lPriors, sd_mh, niter = 10000,
  nchains = 4)
}
\arguments{
\item{wl}{Vector of \code{nwl} wavenumbers at which the spetra are observed.}

\item{spc}{\code{n_y * nwl} Matrix of observed Raman spectra.}

\item{peakWL}{Vector of locations for each peak (cm^-1)}

\item{lPriors}{List of hyperparameters for the prior distributions.}

\item{sd_mh}{Vector of \code{2 * npeaks} bandwidths for the random walk proposals.}

\item{niter}{number of MCMC iterations per chain.}

\item{nchains}{number of concurrent MCMC chains.}
}
\value{
a List containing MCMC samples for the model parameters:
\describe{
  \item{\code{amplitude}}{\code{niter * nchains * npeaks} Array of amplitudes.}
  \item{\code{scale}}{\code{niter * nchains * npeaks} Array of scale parameters.}
  \item{\code{sigma}}{\code{niter * nchains} Matrix of standard deviations.}
  \item{\code{n_acc}}{The number of RWMH proposals that were accepted.}
  }
}
\description{
Fit the model using Markov chain Monte Carlo.
}
\examples{
wavenumbers <- seq(200,600,by=10)
spectra <- matrix(nrow=1, ncol=length(wavenumbers))
peakLocations <- c(300,500)
peakAmplitude <- c(10000,4000)
peakScale <- c(10, 15)
signature <- weightedLorentzian(peakLocations, peakScale, peakAmplitude, wavenumbers)
baseline <- 1000*cos(wavenumbers/200) + 2*wavenumbers
spectra[1,] <- signature + baseline + rnorm(length(wavenumbers),0,200)
lPriors <- list(scale.mu=log(11.6) - (0.4^2)/2, scale.sd=0.4, bl.smooth=10^11, bl.knots=20,
                amp.mu=5000, amp.sd=5000, noise.sd=200, noise.nu=4)
rw_bw <- c(100, 100, 2, 2)
result <- fitSpectraMCMC(wavenumbers, spectra, peakLocations, lPriors, rw_bw, 500)
result$n_acc
}
\seealso{
\code{\link{marginalMetropolisUpdate}}
}
