% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_variables.R
\name{calcBearing}
\alias{calcBearing}
\title{Calculate bearing}
\usage{
calcBearing(list)
}
\arguments{
\item{list}{A list of data frames with separate columns for x and y
coordinate values.}
}
\value{
A list of data frames with a column for the bearing of the organism
  at each time step.
}
\description{
Calculates the bearing (direction of movement) for each time step
}
\details{
This function requires that the data has been previously processed with the
\code{calcXY()} function, providing (x, y) coordinates. Calculate the
direction moved by the organism relative to the y axis between each time step
in your data frames.

If the data will be aggregated, it is recommended to aggregate the data before
running this function.
}
\examples{
# Provide a list of data frames with two columns for the (x, y) coordinates

 servosphere <- list(data.frame(id = rep(1, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("a", 200),
                                date = rep("2032018", 200)),
                     data.frame(id = rep(2, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("b", 200),
                                date = rep("2032018", 200)))
servosphere <- calcXY(servosphere)

servosphere <- calcBearing(servosphere)
}
