% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session-info.R
\name{session_info}
\alias{session_info}
\title{Print session information}
\usage{
session_info(pkgs = NULL, include_base = FALSE)
}
\arguments{
\item{pkgs}{Either a vector of package names or NULL. If \code{NULL},
displays all loaded packages. If a character vector, also, includes
all dependencies of the package.}

\item{include_base}{Include base packages in summary? By default this is
false since base packages should always match the R version.}
}
\description{
This is [base::sessionInfo()] re-written from scratch to both exclude
data that's rarely useful (e.g., the full collate string or base packages
loaded) and include stuff you'd like to know (e.g., where a package was
installed from).
}
\details{
Columns in the *printed* package list:
* `package`: package name
* `*`: whether the package is attached to the search path
* `version`: package version. If the version is marked with `(!)` that
  means that the loaded and the on-disk version of the package are
  different.
* `date`: when the package was built, if this information is available.
  This is the `Date/Publication` or the `Built` field from
  `DESCRIPTION`. (These are usually added automatically by R.)
  Sometimes this data is not available, then it is `NA`.
* `source`: where the package was built or installed from, if available.
  Examples: `CRAN (R 3.3.2)`, `Github (r-lib/pkgbuild@8aab60b)`,
  `Bioconductor`, `local`.

See [package_info()] for the list of columns in the data frame that
is *returned* (as opposed to *printed*).
}
\examples{
session_info()
session_info("sessioninfo")
}
