% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_FuzzySet.R
\name{support}
\alias{support}
\title{Get Support of FuzzySet}
\arguments{
\item{create}{logical, if \code{FALSE} (default) returns the support elements, otherwise returns a \link{Set} of the support elements}
}
\value{
Support elements in fuzzy set or a \link{Set} of the support elements.
}
\description{
The support of a fuzzy set is defined as the set of elements whose membership is greater than zero, or the strong
alpha-cut with \eqn{\alpha = 0},
\deqn{A_\alpha = \{x \epsilon F | m > 0\}}{A_\alpha = {x \epsilon F | m > 0}}
where \eqn{x} is an element in the fuzzy set, \eqn{F}, and \eqn{m} is the corresponding membership.
}
\section{R6 Usage}{
 $support(create = FALSE)
}

\examples{
f = FuzzySet$new(0.1, 0, 1, 0.1, 2, 0.5, 3, 1)
f$support()
f$support(TRUE)
}
\seealso{
\link{core}, \link{alphaCut}
}
