% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testSetList}
\alias{testSetList}
\alias{checkSetList}
\alias{assertSetList}
\title{assert/check/test/SetList}
\usage{
testSetList(object, errormsg = "One or more items in the list are not Sets")

checkSetList(object, errormsg = "One or more items in the list are not Sets")

assertSetList(object, errormsg = "One or more items in the list are not Sets")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is an R6 \code{SetList}.
}
\examples{
testSetList(Set$new(2, 3))
testSetList(list(Set$new(2), Set$new(3)))
testSetList(Tuple$new(2, 3))
testSetList(Interval$new())
testSetList(FuzzySet$new(2, 0.1))
testSetList(FuzzyTuple$new(2, 0.1))
testSetList(ConditionalSet$new(function(x) x == 0))
}
