% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testInterval}
\alias{testInterval}
\alias{checkInterval}
\alias{assertInterval}
\title{assert/check/test/Interval}
\usage{
testInterval(object, errormsg = "This is not an R6 Interval object")

checkInterval(object, errormsg = "This is not an R6 Interval object")

assertInterval(object, errormsg = "This is not an R6 Interval object")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is an R6 \code{Interval}.
}
\examples{
testInterval(Set$new(2, 3))
testInterval(list(Set$new(2), Set$new(3)))
testInterval(Tuple$new(2, 3))
testInterval(Interval$new())
testInterval(FuzzySet$new(2, 0.1))
testInterval(FuzzyTuple$new(2, 0.1))
testInterval(ConditionalSet$new(function(x) x == 0))
}
