% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-task.R
\name{Task}
\alias{Task}
\title{R6 Class representing a Task}
\description{
R6 Class representing a resource for managing tasks.
}
\examples{

## ------------------------------------------------
## Method `Task$print`
## ------------------------------------------------

\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print task object
 task_object$print()
}


## ------------------------------------------------
## Method `Task$reload`
## ------------------------------------------------

\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload task object
 task_object$reload()
}


## ------------------------------------------------
## Method `Task$run`
## ------------------------------------------------

\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Run task
 task_object$run()
}


## ------------------------------------------------
## Method `Task$abort`
## ------------------------------------------------

\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

. # Run task
 task_object$run()

 # Then abort task
 task_object$abort()
}


## ------------------------------------------------
## Method `Task$clone_task`
## ------------------------------------------------

\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Clone task object
 task_object$clone_task()
}


## ------------------------------------------------
## Method `Task$get_execution_details`
## ------------------------------------------------

\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get task execution details
 task_object$get_execution_details()
}


## ------------------------------------------------
## Method `Task$list_batch_children`
## ------------------------------------------------

\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List batch children of a task
 task_object$list_batch_children()
}


## ------------------------------------------------
## Method `Task$delete`
## ------------------------------------------------

\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Delete task
 task_object$delete()
}


## ------------------------------------------------
## Method `Task$rerun`
## ------------------------------------------------

\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Rerun task
 task_object$rerun()
}


## ------------------------------------------------
## Method `Task$update`
## ------------------------------------------------

\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Update task
 task_object$update(name = new_name)
}

}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{Task}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}

\item{\code{id}}{The ID of the task.}

\item{\code{name}}{The name of the task.}

\item{\code{status}}{Task status (different from execution_status).
Allowed values:
\itemize{
\item QUEUED
\item DRAFT
\item RUNNING
\item COMPLETED
\item ABORTED
\item FAILED
}}

\item{\code{description}}{An optional description of a task.}

\item{\code{project}}{Identifier of the project that
the task is located in.}

\item{\code{app}}{The identifier of the app that was used for the task.}

\item{\code{created_by}}{Username of the task creator.}

\item{\code{executed_by}}{Username of the task executor.}

\item{\code{created_on}}{The time in form of string when the task was created.}

\item{\code{start_time}}{Task start time in form of string.}

\item{\code{end_time}}{Task end time in form of string .}

\item{\code{origin}}{Id of the entity that created the task, e.g.
automation run, if task was created by an automation run.}

\item{\code{use_interruptable_instances}}{This field can be \code{TRUE} or
\code{FALSE}. Set this field to \code{TRUE} to allow the use of spot instances.}

\item{\code{batch}}{\code{TRUE} for batch tasks, \code{FALSE} for regular and child
tasks (batch this task; if \code{FALSE}, will not create a batch task).}

\item{\code{batch_by}}{Batching criteria (list).}

\item{\code{batch_group}}{Batch group for a batch task (list). Represents the
group that is assigned to the child task from the batching criteria that
was used when the task was started.}

\item{\code{batch_input}}{Input identifier on to which to apply batching.}

\item{\code{batch_parent}}{Parent task ID for a batch child. (batch task
which is the parent of this task).}

\item{\code{execution_settings}}{Execution settings list for the task.}

\item{\code{execution_status}}{Task execution status list - info about current
execution status.}

\item{\code{errors}}{Validations errors list stored as a high-level errors
array property in the API response.}

\item{\code{warnings}}{Validation warnings list from API response.}

\item{\code{price}}{Task cost (list) - contains amount and currency.}

\item{\code{inputs}}{List of inputs that were submitted to the task.}

\item{\code{outputs}}{List of generated outputs from the task.}

\item{\code{output_location}}{List of locations where task outputs will be
stored.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Task-new}{\code{Task$new()}}
\item \href{#method-Task-print}{\code{Task$print()}}
\item \href{#method-Task-reload}{\code{Task$reload()}}
\item \href{#method-Task-run}{\code{Task$run()}}
\item \href{#method-Task-abort}{\code{Task$abort()}}
\item \href{#method-Task-clone_task}{\code{Task$clone_task()}}
\item \href{#method-Task-get_execution_details}{\code{Task$get_execution_details()}}
\item \href{#method-Task-list_batch_children}{\code{Task$list_batch_children()}}
\item \href{#method-Task-delete}{\code{Task$delete()}}
\item \href{#method-Task-rerun}{\code{Task$rerun()}}
\item \href{#method-Task-update}{\code{Task$update()}}
\item \href{#method-Task-clone}{\code{Task$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-new"></a>}}
\if{latex}{\out{\hypertarget{method-Task-new}{}}}
\subsection{Method \code{new()}}{
Create new Task object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing Task object information.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-print"></a>}}
\if{latex}{\out{\hypertarget{method-Task-print}{}}}
\subsection{Method \code{print()}}{
Print method for Task class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print task object
 task_object$print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-reload"></a>}}
\if{latex}{\out{\hypertarget{method-Task-reload}{}}}
\subsection{Method \code{reload()}}{
Reload Task object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$reload(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Task}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload task object
 task_object$reload()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-run"></a>}}
\if{latex}{\out{\hypertarget{method-Task-run}{}}}
\subsection{Method \code{run()}}{
This call runs (executes) the task. Only tasks whose status
is \code{DRAFT} can be run.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$run(
  batch = NULL,
  use_interruptible_instances = NULL,
  in_place = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{batch}}{Set this to \code{FALSE} to disable the default batching
for this task. Running a batch task is a recommended way to run multiple
tasks considering the API rate limit
(\href{https://docs.sevenbridges.com/docs/api-rate-limit}{learn more}).}

\item{\code{use_interruptible_instances}}{This field can be \code{TRUE} or
\code{FALSE}. Set this field to \code{TRUE} to allow the use of
\href{https://docs.sevenbridges.com/docs/about-spot-instances}{spot instances}.}

\item{\code{in_place}}{Default \code{TRUE}. Should the new object of
Task class be returned or the current to be reinitialized.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Task}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Run task
 task_object$run()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-abort"></a>}}
\if{latex}{\out{\hypertarget{method-Task-abort}{}}}
\subsection{Method \code{abort()}}{
This call aborts the specified task. Only tasks whose
status is \code{RUNNING} or \code{QUEUED} may be aborted.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$abort(in_place = TRUE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{in_place}}{Default \code{TRUE}. Should the new object of
Task class be returned or the current to be reinitialized.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Task}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

. # Run task
 task_object$run()

 # Then abort task
 task_object$abort()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-clone_task"></a>}}
\if{latex}{\out{\hypertarget{method-Task-clone_task}{}}}
\subsection{Method \code{clone_task()}}{
This call clones the specified task. Once cloned, the task
can either be in \code{DRAFT} mode or immediately ran, by setting the \code{run}
parameter to \code{TRUE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$clone_task(run = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{run}}{Set this to \code{TRUE} in order to create a draft task
and execute it immediately. Default: \code{FALSE}.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Task}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Clone task object
 task_object$clone_task()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-get_execution_details"></a>}}
\if{latex}{\out{\hypertarget{method-Task-get_execution_details}{}}}
\subsection{Method \code{get_execution_details()}}{
This call returns execution details of the specified task.
The task is referred to by its ID, which you can obtain by making the
call to list all tasks you can access. The call breaks down the
information into the task's distinct jobs. A job is a single subprocess
carried out in a task. The information returned by this call is broadly
similar to that which can be found in the task stats and logs provided
on the Platform.
The task execution details include the following information:
\itemize{
\item The name of the command line job that executed
\item The start time of the job
\item End time of the job (if it completed)
\item The status of the job (\code{DONE}, \code{FAILED}, or \code{RUNNING})
\item Information on the computational instance that the job was run on,
including the provider ID, the type of instance used and the cloud
service provider
\item A link that can be used to download the standard error logs for the
job.
\item SHA hash of the Docker image ('checksum').
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$get_execution_details(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of execution details.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get task execution details
 task_object$get_execution_details()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-list_batch_children"></a>}}
\if{latex}{\out{\hypertarget{method-Task-list_batch_children}{}}}
\subsection{Method \code{list_batch_children()}}{
This call retrieves batch child tasks for this task if its
a batch task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$list_batch_children(
  status = NULL,
  project = NULL,
  created_from = NULL,
  created_to = NULL,
  started_from = NULL,
  started_to = NULL,
  ended_from = NULL,
  ended_to = NULL,
  order_by = NULL,
  order = NULL,
  origin_id = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{You can filter the returned tasks by their status.
Set the value of status to one of the following values:
\itemize{
\item QUEUED
\item DRAFT
\item RUNNING
\item COMPLETED
\item ABORTED
\item FAILED.
}}

\item{\code{project}}{Provide the project ID or Project object you wish to list
the tasks from.}

\item{\code{created_from}}{Enter the starting date string for querying tasks
created on the specified date and onwards.}

\item{\code{created_to}}{Enter the ending date string for querying tasks
created until the specified date. You can use it in combination with
\code{created_from} to specify a time interval.}

\item{\code{started_from}}{Enter the starting date string for querying tasks
started on the specified date and onwards.}

\item{\code{started_to}}{Enter the ending date string for querying tasks
started until the specified date.}

\item{\code{ended_from}}{Enter the starting date string for querying tasks
that ended on a specified date.}

\item{\code{ended_to}}{Enter the ending date string for querying tasks that
ended until a specified date.}

\item{\code{order_by}}{Order returned results by the specified field.
Allowed values: \cr \code{created_time}, \code{start_time}, \code{name}, \code{end_time} and
\code{created_by}. \cr Sort can be done only by one column. The default
value is \code{created_time}.}

\item{\code{order}}{Sort results in ascending or descending order by
specifying \code{asc} or \code{desc}, respectively. Only taken into account if
\code{order_by} is explicitly specified. The default value is \code{asc}.}

\item{\code{origin_id}}{Enter an automation run ID to list all tasks
created from the specified automation run.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{Task}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List batch children of a task
 task_object$list_batch_children()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Task-delete}{}}}
\subsection{Method \code{delete()}}{
This call deletes the specified task. The task is referred
to by its ID, which you can obtain by making the call to list all tasks
you can access.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$delete(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Delete task
 task_object$delete()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-rerun"></a>}}
\if{latex}{\out{\hypertarget{method-Task-rerun}{}}}
\subsection{Method \code{rerun()}}{
This call reruns (executes) the specified task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$rerun(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Task}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Rerun task
 task_object$rerun()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-update"></a>}}
\if{latex}{\out{\hypertarget{method-Task-update}{}}}
\subsection{Method \code{update()}}{
Change the details of the specified task, including its
name, description, and inputs. Note that you can only modify tasks with
a task status of \code{DRAFT}. Tasks which are \code{RUNNING}, \code{QUEUED},
\code{ABORTED}, \code{COMPLETED} or \code{FAILED} cannot be modified in order to
enable the reproducibility of analyses which have been queued for
execution or has initiated executing.
There are two things to note if you are editing a batch task:
\itemize{
\item \code{1} If you want to change the input on which to batch and
the batch criteria, you need to specify the batch_input and batch_by
parameters together in the same function call.
\item \code{2} If you want to disable batching on a task, set batch to
false. Or, you can also set the parameters batch_input and batch_by
to NULL.
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$update(
  name = NULL,
  description = NULL,
  execution_settings = NULL,
  inputs = NULL,
  output_location = NULL,
  batch = NULL,
  batch_input = NULL,
  batch_by = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the task.}

\item{\code{description}}{An optional description of the task.}

\item{\code{execution_settings}}{Named list with detailed task execution
parameters. Detailed task execution parameters:
\itemize{
\item \code{instance_type}: Possible value is the specific instance type,
e.g. \code{"instance_type" = "c4.2xlarge;ebs-gp2;2000"};
\item \code{max_parallel_instances}: Maximum number of instances
running at the same time. Takes any integer value equal to or
greater than 1, e.g. \code{"max_parallel_instances" = 2.};
\item \code{use_memoization}: Set to \code{FALSE} by default. Set to \code{TRUE}
to enable
\href{https://docs.sevenbridges.com/docs/about-memoization}{memoization};
\item \code{use_elastic_disk}: Set to \code{TRUE} to enable
\href{https://docs.sevenbridges.com/page/elastic-disk}{Elastic Disk}.
}

Here is an example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{execution_settings <- list(
  "instance_type" = "c4.2xlarge;ebs-gp2;2000",
  "max_parallel_instances" = 2,
  "use_memoization" = TRUE,
  "use_elastic_disk" = TRUE
  )
}\if{html}{\out{</div>}}}

\item{\code{inputs}}{List of objects. See the section on
\href{https://docs.sevenbridges.com/docs/the-api#section-inputs}{specifying task inputs}
for information on creating task input objects. Here is an example with
various input types:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{inputs <- list(
  "input_file"= "<file_id/file_object>",
  "input_directory" = "<folder_id/folder_object>",
  "input_array_string" = list("<string_elem_1>", "<string_elem_2>"),
  "input_boolean" = TRUE,
  "input_double" = 54.6,
  "input_enum" = "enum_1",
  "input_float" = 11.2,
  "input_integer" = "asdf",
  "input_long" = 4212,
  "input_string" = "test_string",
  "input_record" = list(
    "input_record_field_file" = "<file_id/file_object>",
    "input_record_field_integer" = 42
   )
  )
}\if{html}{\out{</div>}}}

\item{\code{output_location}}{The output location list allows you to
define the exact location where your task outputs will be stored.
The location can either be defined for the entire project using the
main_location parameter, or individually per each output node, by
setting the nodes_override parameter to true and defining individual
output node locations within nodes_location.
See below for more details.
\itemize{
\item \code{main_location} - Defines the output location for all
output nodes in the task. Can be a string path within the project in
which the task is created, for example \cr
\verb{/Analysis/<task_id>_<task_name>/}
or a path on an attached volume, such as \cr
\verb{volumes://volume_name/<project_id>/html}.
Parts of the path enclosed in angle brackets <> are tokens that are
dynamically replaced with corresponding values during task
execution.
\item \code{main_location_alias}: The string location (path) in the
project that will point to the actual location where the outputs are
stored. Used if main_location is defined as a volume path (starting
with volumes://), to provide an easy way of accessing output data
directly from project files.
\item \code{nodes_override}: Enables defining of output locations
for output nodes individually through nodes_location (see below).
Set to \code{TRUE} to be able to define individual locations per output
node. Default: \code{FALSE}.
Even if nodes_override is set to \code{TRUE}, it is not necessary to
define output locations for each of the output nodes individually.
Data from those output nodes that don't have their locations
explicitly defined through nodes_location is either placed in
main_location (if defined) or at the project files root if a main
output location is not defined for the task.
\item \code{nodes_location}: List of output paths for individual
task output nodes in the following format for each output node:\cr
\verb{<output-node-id> = list(} \cr
\verb{"output_location" = "<output-path>",} \cr
\code{"output_location_alias" = "<alias-path>"} \cr
\verb{)} \cr
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{b64html = list(
 "output_location" = "volumes://outputs/tasks/mar-19",
 "output_location_alias" = "/rfranklin/tasks/picard"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{ In the example above, b64html is the ID of the output node for which
 you want to define the output location, while the parameters are
 defined as follows:
}\if{html}{\out{</div>}}

\itemize{
\item \code{output_location} - Can be a path within the project in which
the task is created, for example
\verb{/Analysis/<task_id>_<task_name>/}
or a path on an attached volume, such as
\verb{volumes://volume_name/<project_id>/html}. Also accepts tokens.
\item \code{output_location_alias} - The location (path) in the project
that will point to the exact location where the output is stored.
Used if output_location is defined as a volume path
(starting with volumes://).
}
}}

\item{\code{batch}}{This is set to \code{FALSE} by default. Set to \code{TRUE} to
create a batch task and specify the \code{batch_input} and \code{batch-by}
criteria as described below.}

\item{\code{batch_input}}{The ID of the input on which you wish to batch.
You would typically batch on the input consisting of a list of files.
If this parameter is omitted, the default batching criteria defined for
the app will be used.}

\item{\code{batch_by}}{Batching criteria in form of list. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{batch_by = list(
  type = "CRITERIA",
  criteria = list("metadata.condition")
)
}\if{html}{\out{</div>}}}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Task}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when task is requested
task_object <- Task$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Update task
 task_object$update(name = new_name)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Task-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
