% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{st_write_db}
\alias{st_write_db}
\title{write simple feature table to a spatial database}
\usage{
st_write_db(conn = NULL, obj, table = substitute(obj),
  geom_name = "wkb_geometry", ..., dropTable = FALSE, binary = TRUE)
}
\arguments{
\item{conn}{open database connection}

\item{obj}{object of class \code{sf}}

\item{table}{name for the table in the database}

\item{geom_name}{name of the geometry column in the database}

\item{...}{arguments passed on to \code{dbWriteTable}}

\item{dropTable}{logical; should \code{table} be dropped first?}

\item{binary}{logical; use well-known-binary for transfer?}
}
\description{
write simple feature table to a spatial database
}
\examples{
if (Sys.getenv("USER") \%in\% c("travis", "edzer")) {
  library(sp)
  data(meuse)
  sf = st_as_sf(meuse, coords = c("x", "y"), crs = 28992)
  library(RPostgreSQL)
  conn = dbConnect(PostgreSQL(), dbname = "postgis")
  st_write_db(conn, sf, "meuse_tbl", dropTable = FALSE)
}
}

